#define VA 23
#define ALR 7
#define ALY 6 
#define ALG 5
#define AB 8

#define VB 24
#define BLR 4 
#define BLY 3 
#define BLG 2
#define BB 9

#define Y_DELAY 1000
#define CH_DELAY 3000

/*
  Esta função muda o estado da via selecionada.
    ch([byte via], [bool estado])
    ch(VA,true) abre a via A 
*/

void ch(byte v, bool s){
  if(v == VA){
    pinMode(ALR, LOW);
    pinMode(ALY, LOW);
    pinMode(ALG, LOW);
    if(s){
      pinMode(ALY, HIGH);
      delay(Y_DELAY);
      pinMode(ALY, LOW);
      pinMode(ALG, HIGH);
    }else{
      pinMode(ALY, HIGH);
      delay(Y_DELAY);
      pinMode(ALY, LOW);
      pinMode(ALR, HIGH);
    }
  }else if(v == VB){
    pinMode(BLR, LOW);
    pinMode(BLY, LOW);
    pinMode(BLG, LOW);
    if(s){
      pinMode(BLY, HIGH);
      delay(Y_DELAY);
      pinMode(BLY, LOW);
      pinMode(BLG, HIGH);
    }else{
      pinMode(BLY, HIGH);
      delay(Y_DELAY);
      pinMode(BLY, LOW);
      pinMode(BLR, HIGH);
    }
  }
}

void setup() {
  
  pinMode(ALR, OUTPUT);
  pinMode(ALY, OUTPUT);
  pinMode(ALG, OUTPUT);
  pinMode(AB, INPUT);
  
  pinMode(BLR, OUTPUT);
  pinMode(BLY, OUTPUT);
  pinMode(BLG, OUTPUT);
  pinMode(BB, INPUT);
}

void loop() {
  if(digitalRead(AB)){
    ch(VA, false);
    ch(VB, true);
    delay(CH_DELAY);
  }else if(digitalRead(BB)){
    ch(VA, true);
    ch(VB, false);
    delay(CH_DELAY);
  }else{
    ch(VA, true);
    ch(VB, false);
    delay(CH_DELAY);
    ch(VA, false);
    ch(VB, true);
    delay(CH_DELAY);
  }
}
