
"""node_request_list

node_get_user_loc

node_send_messg"""
import config
import logger
import payload

import time
import socket

class network:
    global node_list
    node_list = []
    
    class node:
        def __init__(self, ip,):
            self.ip = ip
            self.port = config.PROTOCOL_PORT
            self.clients = []
            self.time = int(time.time())
        
    def is_local(tripcode, peer_arr):
        global node_list
        for peer in peer_arr:
            if peer.loged_in and peer.is_client and peer.active:
                if tripcode == peer.tripcode:
                    return True
        return False
                
    def search_for_client(tripcode):        
        global node_list
        s = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
        for node in node_list:
            if tripcode in node.clients:
                return node.ip
            else:
                try:
                    s.connect((node.ip, config.PROTOCOL_PORT))
                except:
                    logger.p("Falha a obter informação sobre a rede")
                    break
                s.send(payload.node.lookup(tripcode).encode())
                opcode, msg = payload.decode(0,s.recv(config.SOCKET_BUFFER_SIZE))
                
                if opcode == 12:
                    if msg['result']:
                        node.clients.append(tripcode)
                        return node.ip
                    else:
                        for node_ip in msg['known_nodes']:
                            update_list(node_ip)
            
        
    def update_list(node_ip):
        global node_list
        
        if not node_ip == config.SELF_EXT_IP:
            is_new = True
            for node in node_list:
                if node_ip == node.ip:
                    is_new = False
            if is_new:
                node_list.append(network.node(node_ip))

    def get_node_list():
        global node_list
        return node_list
    
    def init():
        global node_list

        network.update_list(config.UPSTART_SERVER_IP)
        
        s = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
        try:
            s.connect((config.UPSTART_SERVER_IP, config.PROTOCOL_PORT))
        except:
            logger.p("Falha a obter informação sobre a rede")
            return False
        s.send(payload.node.lookup("start#00000000000000").encode())
        opcode, msg = payload.decode(0,s.recv(config.SOCKET_BUFFER_SIZE))
        
        s.shutdown(socket.SHUT_RDWR)
        s.close()
        
        if not opcode == 12:
            return False
        
        for node_ip in msg['known_nodes']:
            network.update_list(node_ip)
        
        return True
        
    def update_clients_in_node(node_ip, client_trip):
        global node_list
        for node in node_list:
            if node.ip == node_ip:
                if not client_trip in node.clients:
                    node.clients.append(client_trip)
                    
    def get_node_index_from_ip(node_ip):
        global node_list
        for index, node in enumerate(node_list):
            if node.ip == node_ip:
                return index 

    def list_of_node_addresses():
        global node_list
        address_list = []
        for node in node_list:
            address_list.append(node.ip)
        
        return address_list
