import json
import time

import logger

"""
client operations to server
client -> server || node(server)->node(server)

client receive
keepalive response 0 garante ao cliente que o socket funciona
auth               1 contem a pub key ou a resolução !!autenticação com 3 passos todos no mesmo pacote
message            2 client message to broadcast in channel (TOAD) or dm
logout             3 client is disconecting
"""

def decode(source_client_i,d): ##recived from client
    try:
        json_dict = json.loads(d)
    except ValueError:
        logger.p("Erro a analizar JSON")
        return (False, None)
    
    if not 'op' in json_dict:
        logger.p("JSON invalido")
        return (False, None)

    opcode = int(json_dict['op'])
    
    logger.p(json_dict)
    
    if opcode == 0:
        return (opcode, None)      
    elif opcode == 1:
        return (opcode, json_dict)
    elif opcode == 2:
        if 'message' in json_dict and 'chan' in json_dict:
            return (opcode, json_dict)
        else:
            return (False, "Comando malformado")
    elif opcode == 3:
        return (opcode, json_dict)
    elif opcode == 11:
        return (opcode, json_dict)
    elif opcode == 12:
        return (opcode, json_dict)    
    elif opcode == 13:
        return (opcode, json_dict)
    else:
        return (False, "Comando N Suportado")
    
    
"""
server operations to client
server -> client
keepalive ping      0 to check for dead connections ##lembrar: é facil de verificar o estado de um socket tcp usando-o
        ##peerstaus update op 1 eliminado
auth_challenge      2 contem o desafio ou o estado da auth
message             3 mensagem que proveio da rede
disconnect notice   4 when server wants to tell the client to disconnect

"""
class client:
    def mk_keep_alive():
        payload = {
            "op": 0,
            "server_time": int(time.time())
        }
        return json.dumps(payload)

    def mk_auth_key(pub_key):
        payload = {
            "op": 2,
            "public_key": pub_key,
            "time": time.time()
        }
        return json.dumps(payload)

    def mk_auth_challenge(challenge):
        payload = {
            "op": 2,
            "challenge":challenge,
            "time": int(time.time())
        }
        return json.dumps(payload)


    def mk_auth_response(auth_status = -1, tripcode = None):
        auth_success = False
        if auth_status == -1:
            auth_msg = "Server is Full."
        elif auth_status == -2:
            auth_msg = "Challenge failed."
        elif auth_status == 0:
            auth_msg = "Sucessfuly loged in"
            auth_success = True
        elif auth_status == 1:
            auth_msg = "Your address is blacklisted."
        else:
            auth_msg = "Unknown Server Error: Pool is closed due to aids."
        
        payload = {
            "op": 2,
            "auth_status": auth_status,
            "auth_msg": auth_msg,
            "auth_success": auth_success,
            "tripcode": tripcode ##ultimos 14 digitos da hash da pubkey
        }
        return json.dumps(payload)
        
    def mk_text_message(s_trip = None, m = 'check payload.mk_text_message calls with missing args', c = 'geral'):
        if s_trip == None:
            logger.p("check args",m)
            return None
        
        payload = {
            "op": 3,
            "message": m,  ## message to be displayed
            "chan": c,  ###localization descriptor
            "sender_tripcode": s_trip,
            "server_time": int(time.time())
        }    
        return json.dumps(payload)

    def mk_server_shutdown():
        payload = {
            "op": 4,
            "server_time": int(time.time())
        }
        return json.dumps(payload)



    def mk_safe_str(s):
        return s.replace('\x1b','')
    

"""
internode send
lookup_request  11 
pergunta a um node por o estado de um client
    é reencaminhado caso o cliente n exista
    fechar socket depois da resposta
    
lookup_response 12
responde que o node tem o 

relay 13
 op 13 - operation
 send - sender remetente
 dest - destinatary destinatario
 obj  - 
 time - tempo

ou LEGACY

auth_internode  13
(4 passos e começa com a requisição da chave publica)
  1 pedir chave publica   
  2 receber chave publica 
  3 enviar problema cryptografico
  4 receber e verificar solução
    manter socket aberto a espera de mensagens o da desconecção ou timeout (16) secs
                                
    dm_message      14
    contem uma mensagem direta
        só pode ser recebido depois da autenticação do cliente
        pode ser recebido uma vez depois de autenticado 
"""
class node:
    def lookup(tripcode = None):
        if tripcode == None:
            return
        
        payload = {
            "op": 11,
            "tripcode": tripcode,
            "time": int(time.time())
        }
        
        return json.dumps(payload)
        
    def response(result, known_nodes):
        payload = {
            "op": 12,
            "result": result,
            "known_nodes": known_nodes,
            "time": int(time.time())
        }
        
        return json.dumps(payload)

class peers:
    def relay(s_t = None, d_t = None, m_o = None):
        if s_t == None or d_t == None or m_o == None:
            return False
            
        payload = {
            "op": 13,
            "sender_t": s_t,
            "dest_t": d_t,
            "msg_obj": m_o,
            "server_time": int(time.time()),
        }
        return json.dumps(payload)
