import websocket, json, threading, time, select

OPERATION_SEQUENCE = 0
KEEP_ALIVE = True
RESTART_CONNECTION = False
TOKEN = "0"

def main():
	handle_connection(TOKEN)

def handle_connection(TOKEN):
    sock = create_socket()
    hello = sock.recv()
    hello = json.loads(hello)
    ##handle id
    
    
    
    
    ## heartbeat
    bot_brainstem(sock, hello["d"]["heartbeat_interval"])
    if RESTART_CONNECTION:
        kill_connection(sock)
        handle_connection(TOKEN)
    else:
        kill_connection(sock)
        return
		
def kill_connection(sock):
	kill_socket(sock)
	return

def bot_brainstem(sock, interval):
    while KEEP_ALIVE:
        if OPERATION_SEQUENCE == 4: #
            break #
        heartbeat = make_packet("heartbeat", OPERATION_SEQUENCE)
        print(heartbeat)
        sock.send(heartbeat)
        ack = sock.recv()
        print(ack)
        if not ack == "":
            ack = decode_packet(ack)
            if code_to_name(ack["op"]) == "heartbeat-ack":
                time.sleep(interval/1e3/8) #
                continue
        else:
            time.sleep(interval/1e3/8) #
            ack = sock.recv()
            if not ack == "":
                ack = packet_decode(ack)
                if code_to_name(ack["op"]) == "heartbeat-ack":
                    continue
            else:
                RESTART_CONNECTION = True
                return
    return

def create_socket():
    RESTART_CONNECTION = False
    return websocket.create_connection("wss://gateway.discord.gg/?v=6&encoding=json")

def kill_socket(sock):
    sock.close()

def make_packet(name = "dispatch",payload = {}):
    global OPERATION_SEQUENCE
    code = name_to_code(name)
    cname = code_to_cname(code)
    
    if code == 0:
        packet = {
            "op": code,
            "d": payload,
            "s": OPERATION_SEQUENCE,
            "t": cname
        }
        OPERATION_SEQUENCE+=1   
    else:
        packet = {
            "op": code,
            "d": payload
        }
        OPERATION_SEQUENCE+=1
    if payload == {}:
        packet = {
            "op": code,
        }
        
    packet = json.dumps(packet)
    return packet

def decode_packet(packet):
    return json.loads(packet)

def make_id(TOKEN, client_agent={"$os":"linux","$browser":"liug.py","$device":"iug_BOT"},):

def name_to_code(name):
    name = name.lower()
    name_list = {
        "dispatch": 0,
        "heartbeat": 1,
        "identify": 2,
        "status-update": 3,
        "voice": 4,
        "resume": 6,
        "reconnect": 7,
        "guild-members":8,
        "invalid":9,
        "hello":10,
        "heartbeat-ack":11
    }
    code = name_list[name]
    return code

def code_to_name(code):
    name_list = [
        "dispatch",
        "heartbeat",
        "identify",
        "status-update",
        "voice",
        "twoplustwoisfive",
        "resume",
        "reconnect",
        "guild-members",
        "invalid",
        "hello",
        "heartbeat-ack"
    ]
    name = name_list[code]
    return name

def code_to_cname(code):
    name_list = [
        "Dispatch",
        "Heartbeat",
        "Identify",
        "Status Update",
        "Voice Status Update",
        "Discord Dev Can't Count",
        "Resume",
        "Reconnect",
        "Request Guild Members",
        "Invalid Session",
        "Hello",
        "Heartbeat ACK"
    ]
    name = name_list[code]
    return name
main()
