import requests
from PIL import Image, ImageFilter
from lxml import html
from selenium import webdriver
from selenium.webdriver.firefox.options import Options
import imghdr
import random
import json
import time

import config

def init():
    options = Options()
    options.headless = True
    return webdriver.Firefox(options=options,executable_path=config.geckodriver_path)

sel_driver = init()

def kill():
    sel_driver.close()
    sel_driver.quit()

def update_good_image(querry):
    f_name = "gischfr"
    target_w = 700
    
    sel_driver.get("https://www.google.com/search?tbm=isch&q="+querry)

    try:
        elems = sel_driver.find_elements_by_class_name("rg_meta")
        elem_text = elems[0].get_attribute('innerHTML')
    except (IndexError,ValueError):
        sel_driver.save_screenshot(config.error_screenshots_path + str(int(time.time())) + ".png")
        print("gimg_d:not enought results")
        return False , "Error: You have a esoteric taste.\n Couldn't find results."

    elem_json = json.loads(elem_text)
    img_url = elem_json['ou']
    
    image = requests.get(img_url)
    
    is_screenshot = False
    f_extension = imghdr.what("nofile",image.content)
    if f_extension == None:
        if image.content[:3] == b'\xff\xd8\xff' and image.content[-2:] == b'\xff\xd9':
            f_extension = "jpeg"
        else:
            is_screenshot = True
            f_extension = "png"
            sel_driver.get(img_url)
            sel_driver.save_screenshot(config.cwd+f_name+"."+f_extension)
            print("GOT A SCREENSHOT OF A WEBPAGE")
            
    if not(is_screenshot):
        file = open(config.cwd+f_name+"."+f_extension, "wb")
        file.write(image.content)
        file.close()
    else:
        print("POSTING A SCREENSHOT OF A WEBPAGE")
    
    im = Image.open(config.cwd+f_name+"."+f_extension)
    im = im.convert('RGB')
    im_w, im_h = im.size
    original_ratio = target_w/im_w
    im = im.resize((target_w,int(im_h*original_ratio)),Image.LANCZOS)
    im.save(config.cwd+f_name+"."+f_extension)
    
    return True , str(config.cwd+f_name+"."+f_extension)

def update_shit_image(querry):
    f_name = "gischfr.jpg"
    target_w = 700

    page = requests.get('https://www.google.com/search?tbm=isch&gbv=1&q='+querry)
    tree = html.fromstring(page.content)
    
    try:
        images_table = tree.xpath("//table[@class='images_table']")[0]
    except:
        return False , "Error: This tube did not have what You wanted."

    image_elements = images_table.xpath("(//img)")
    result = image_elements[random.randint(1,min(len(image_elements)-1,3))].attrib['src']
    if not result.startswith("http"):
        return False , "Error: The cunt-fused webserver strikes back."

    image = requests.get(result)
    
    file = open(config.cwd+f_name, "wb")
    file.write(image.content)
    file.close()

    im = Image.open(config.cwd+f_name)
    im_w, im_h = im.size
    original_ratio = target_w/im_w
    
    im = im.resize((target_w,int(im_h*original_ratio)),Image.LANCZOS)
    im = im.convert('RGB')
    try:
        im.save(config.cwd+f_name)
    except OSError as error:
        return False, "Error: Call iug cuz I just shat my pantsu~~.\n" + str(error)
    return True, config.cwd+f_name
