<?php 

function userExists($user){
    include('/phpcred/pdolog.php');
    $sql = $conn->prepare("SELECT * FROM usr_table WHERE usr_nick = :nick LIMIT 1");
    $sql->bindParam(':nick', $user, PDO::PARAM_STR);
    if($sql->execute()){
        if($sql->rowCount()){
            return true;
        }else{
            return false;
        }
    }
}

function whoPosted($number){
    include('/phpcred/pdolog.php');
    $sql = $conn->prepare("SELECT * FROM userStringTable WHERE InputNumber = :number LIMIT 1");
    $sql->bindParam(':number', $number, PDO::PARAM_STR);
    $sql->execute();
    if($sql->rowCount() == 0){
	return false;
    }
    $row = $sql->fetch(PDO::FETCH_ASSOC);
    $user = $row['name'];

    return strip_tags($user);
}

function timeSinceLastPost($user,$table = "none"){
    include('/phpcred/pdolog.php');
    if(!strcmp($table,"ust")){
        $sql = $conn->prepare("SELECT TimeENTER, InputNumber FROM userStringTable WHERE name = :name ORDER BY InputNumber DESC LIMIT 1");
        $sql->bindParam(':name', $name, PDO::PARAM_STR);
        $sql->execute();
        $row = $sql->fetch(PDO::FETCH_ASSOC);
        $time = $row['TimeENTER'];
    }elseif(!strcmp($table,"ic")){
        $sql = $conn->prepare("SELECT timestamp, counterglob FROM imgComs WHERE name = :name ORDER BY counterglob DESC LIMIT 1");
        $sql->bindParam(':name', $name, PDO::PARAM_STR);
        $sql->execute();
        $row = $sql->fetch(PDO::FETCH_ASSOC);
        $time = $row['timestamp'];
    }elseif(!strcmp($table,"im")){
        $sql = $conn->prepare("SELECT update_date, id_img, usename_img FROM imgtable WHERE usename_img = :name ORDER BY id_img DESC LIMIT 1");
        $sql->bindParam(':name', $name, PDO::PARAM_STR);
        $sql->execute();
        $row = $sql->fetch(PDO::FETCH_ASSOC);
        $time = $row['update_date'];
    }

    if($row){
        $last = new DateTime($time);
        $now = new DateTime(date("Y-m-d H:i:s"));
        $lasts = $last->getTimestamp();
        $nows = $now->getTimestamp();
        $dif = $nows - $lasts;
        return $dif;
    }
    return 5000;
}

function captchaVerify($captcha = NULL){
if(!isset($_SESSION['user'])){
        if (!empty($captcha)) {
            $secret = "6Ldk3RkUAAAAAMn-sWI08Rw8S-6kmPP3cxzLqzI_";
            $response = file_get_contents("https://www.google.com/recaptcha/api/siteverify?secret=".$secret."&response=".$captcha);
            $responseKeys = json_decode($response,true);
            if(intval($responseKeys["success"]) !== 1) {
                return 1;
            } else {
                return 0;
            }
        }else{
            return 2;
        }
    }
}

function imageOwner($image){
    include('/phpcred/pdolog.php');
    $sql = $conn->prepare("SELECT * FROM imgtable WHERE filename_img = :fname  LIMIT 1");
    $sql->bindParam(':fname', $image, PDO::PARAM_STR);
    $sql->execute();
    if($sql->rowCount() == 0){
        return "noimage";
    }else{
        $row = $sql->fetch(PDO::FETCH_ASSOC);
        return $row['usename_img'];
    }
}


function sanitizeName($name){

    $name = preg_replace("/iug|admin|anon|webmaster|moderator|ceo/i", "Anon", $name);
    $name = $_POST['name'];
    $name = strip_tags($name);
    $nameL = nl2br($name);
    
	if (empty($name)){
	$name = "Anon";
	}
	
    $name = strlen($nameL) > 200 ? substr($nameL,0,200) : $nameL;
    return $name;
}

function sanitizeText($text){
    $text = strip_tags($text);

    $text = str_ireplace(":b:","<b>",$text);
    $text = str_ireplace(";b;","</b>",$text);

    $text = str_ireplace(":i:","<i>",$text);
    $text = str_ireplace(";i;","</i>",$text);

    $text = str_ireplace(":del:","<del>",$text);
    $text = str_ireplace(";del;","</del>",$text);

    $text = str_ireplace(":ins:","<ins>",$text);
    $text = str_ireplace(";ins;","</ins>",$text);

    $text = preg_replace("/(http|https)\:\/\/[a-zA-Z0-9\-\.]+\.[a-zA-Z]{2,3}(\/\S*)?/", "<a class=\"prslink\" href=\"$0\">$0</a>", $text);
	$text = preg_replace("/(>>[0-9]+)/","<a style=\"color:blue;\" href=\"#$1\">$1</a>",$text);

    $text = nl2br($text);
    if(substr_count($text,"<br />") > 10) {
        return false;
    }
    return $text;
}

function toAscii($str, $replace=array(), $delimiter='-') {
	 if( !empty($replace) ) {
	  $str = str_replace((array)$replace, ' ', $str);
	 }

	 $clean = iconv('UTF-8', 'ASCII//IGNORE', $str);
	 $clean = preg_replace("/[^a-zA-Z0-9._|+ -]/", '', $clean);
	 $clean = strtolower(trim($clean, '-'));
	 $clean = preg_replace("/[\/_|+ -]+/", $delimiter, $clean);

	 return $clean;
}

function redirect($url, $permanent = false){
    header('Location: ' . $url, true, $permanent ? 301 : 302);
    return 0;
}

function getUserPrevilege($user, $intval = true){
    include('/phpcred/pdolog.php');
    $sql = $conn->prepare("SELECT * FROM usr_table WHERE usr_nick=:uname");
    $sql->bindParam(':uname', $user, PDO::PARAM_STR);
    $sql->execute();
    $row = $sql->fetch(PDO::FETCH_ASSOC);
    $plvl = intval($row['usr_previlege']);
    
    if($intval == true){
        return $plvl;
    }else{
        if($plvl == 4){
            $plvls = "Fundador";
        }elseif($plvl == 3){
            $plvls = "Administrador";
        }elseif($plvl == 2){
            $plvls = "Moderador";
        }elseif($plvl == 1){
            $plvls = "Utilizador Verificado";
        }else{
            $plvls = "Utilizador Não Verificado";
        }
        return $plvls;
    }
}

function topPageCreate($title = "",$headcont = ""){
		echo '<!DOCTYPE html>
<html>
<head>
	<title>Lista do Iug - '.$title.'</title>
	<link href="/style/stylelist.css" rel="stylesheet" type="text/css"/>
	<meta name="keywords" content="Lista,IUG,iug,lista,do,Memes,cp">
	<meta charset="UTF-8">
	<meta name="viewport" content="width=device-width" />
	<script src="/scripts/jsscroll.js"></script>
	<script src="/scripts/particles.min.js"></script>
	<script src="/scripts/particlesload.js"></script>
	'.$headcont.'
</head>
<body>
<div class="head">
	 <div class="buttons">
		 <div class="9fagmenu">
			<ul id="m">'; 
            if (isset($_SESSION['user'])) {
                echo "<li class='l'><a href=\"/apannel/\">AdminPan</a></li>";
                echo "<li class='l' style=\"font-size:0.49em;\"><a href=\"/login/\"><sub>Utilizador:</sub><br>".$_SESSION['user']."</a></li>";
            }else{
                echo "<li class='l'><a href=\"/login/reg\">Registar</a></li>";
                echo "<li class='l'><a href=\"/login/\">Login</a></li>";
            }
		    echo "<li class='l'><a href=\"/fileup/\">Carregar</a></li>
			  <li class='l'><a href=\"/phpdata/\">Bostik</a></li>
			  <li class='l'><a href=\"/ind/\">&Iacute;ndices</a></li>
			  <li class='l'><a href=\"/\">Principal</a></li>
			  <li class='l' id=\"lilogo\"><a href=\"#\">Lista do iug</a></li>
			</ul>
		 </div>
  </div>
</div>
<div id=\"particles-js\"></div>
	<div class=\"main\">
	 <div class=\"container\">
	  <div class=\"content\">
	   <div class=\"enrol\">";
	return 0;
}

function bottomPageCreate(){
	echo "		</div>
	  </div>
	 </div>
	</div>
</body>
</html>";
return 0;
}

?>
