/* -----------------------------------------------
/* Author : Vincent Garreau  - vincentgarreau.com
/* MIT license: http://opensource.org/licenses/MIT
/* Demo / Generator : vincentgarreau.com/particles.js
/* GitHub : github.com/VincentGarreau/particles.js
/* How to use? : Check the GitHub README
/* v2.0.0
/* ----------------------------------------------- */
function hexToRgb(e) {
    var a = /^#?([a-f\d])([a-f\d])([a-f\d])$/i;
    e = e.replace(a, function(e, a, t, i) {
        return a + a + t + t + i + i
    });
    var t = /^#?([a-f\d]{2})([a-f\d]{2})([a-f\d]{2})$/i.exec(e);
    return t ? {
        r: parseInt(t[1], 16),
        g: parseInt(t[2], 16),
        b: parseInt(t[3], 16)
    } : null
}

function clamp(e, a, t) {
    return Math.min(Math.max(e, a), t)
}
function isInArray(e, a) {
    return a.indexOf(e) > -1
}
var pJS = function(e, a) {
    var t = document.querySelector("#" + e + " > .particles-js-canvas-el");
    this.pJS = {
        canvas: {
            el: t,
            w: t.offsetWidth,
            h: t.offsetHeight
        },
        particles: {
            number: {
                value: 400,
                density: {
                    enable: !0,
                    value_area: 800
                }
            },
            color: {
                value: "#fff"
            },
            shape: {
                type: "circle",
                stroke: {
                    width: 0,
                    color: "#ff0000"
                },
                polygon: {
                    nb_sides: 5
                },
                image: {
                    src: "",
                    width: 100,
                    height: 100
                }
            },
            opacity: {
                value: 1,
                random: !1,
                anim: {
                    enable: !1,
                    speed: 2,
                    opacity_min: 0,
                    sync: !1
                }
            },
            size: {
                value: 20,
                random: !1,
                anim: {
                    enable: !1,
                    speed: 20,
                    size_min: 0,
                    sync: !1
                }
            },
            line_linked: {
                enable: !0,
                distance: 100,
                color: "#fff",
                opacity: 1,
                width: 1
            },
            move: {
                enable: !0,
                speed: 2,
                direction: "none",
                random: !1,
                straight: !1,
                out_mode: "out",
                bounce: !1,
                attract: {
                    enable: !1,
                    rotateX: 3e3,
                    rotateY: 3e3
                }
            },
            array: []
        },
        interactivity: {
            detect_on: "canvas",
            events: {
                onhover: {
                    enable: !0,
                    mode: "grab"
                },
                onclick: {
                    enable: !0,
                    mode: "push"
                },
                resize: !0
            },
            modes: {
                grab: {
                    distance: 100,
                    line_linked: {
                        opacity: 1
                    }
                },
                bubble: {
                    distance: 200,
                    size: 80,
                    duration: .4
                },
                repulse: {
                    distance: 200,
                    duration: .4
                },
                push: {
                    particles_nb: 4
                },
                remove: {
                    particles_nb: 2
                }
            },
            mouse: {}
        },
        retina_detect: !1,
        fn: {
            interact: {},
            modes: {},
            vendors: {}
        },
        tmp: {}
    };
    var i = this.pJS;
    a && Object.deepExtend(i, a),
    i.tmp.obj = {
        size_value: i.particles.size.value,
        size_anim_speed: i.particles.size.anim.speed,
        move_speed: i.particles.move.speed,
        line_linked_distance: i.particles.line_linked.distance,
        line_linked_width: i.particles.line_linked.width,
        mode_grab_distance: i.interactivity.modes.grab.distance,
        mode_bubble_distance: i.interactivity.modes.bubble.distance,
        mode_bubble_size: i.interactivity.modes.bubble.size,
        mode_repulse_distance: i.interactivity.modes.repulse.distance
    },
    i.fn.retinaInit = function() {
		return false;
    }
    ,
    i.fn.canvasInit = function() {
        i.canvas.ctx = i.canvas.el.getContext("2d")
    }
    ,
    i.fn.canvasSize = function() {
        i.canvas.el.width = i.canvas.w,
        i.canvas.el.height = i.canvas.h
    }
    ,
    i.fn.canvasPaint = function() {
        i.canvas.ctx.fillRect(0, 0, i.canvas.w, i.canvas.h)
    }
    ,
    i.fn.canvasClear = function() {
        i.canvas.ctx.clearRect(0, 0, i.canvas.w, i.canvas.h)
    }
    ,
    i.fn.particle = function(e, a, t) {
        if (this.radius = (i.particles.size.random ? Math.random() : 1) * i.particles.size.value,
        i.particles.size.anim.enable && (this.size_status = !1,
        this.vs = i.particles.size.anim.speed / 100,
        i.particles.size.anim.sync || (this.vs = this.vs * Math.random())),
        this.x = t ? t.x : Math.random() * i.canvas.w,
        this.y = t ? t.y : Math.random() * i.canvas.h,
        this.x > i.canvas.w - 2 * this.radius ? this.x = this.x - this.radius : this.x < 2 * this.radius && (this.x = this.x + this.radius),
        this.y > i.canvas.h - 2 * this.radius ? this.y = this.y - this.radius : this.y < 2 * this.radius && (this.y = this.y + this.radius),
        i.particles.move.bounce && i.fn.vendors.checkOverlap(this, t),
        this.color = {},
        "object" == typeof e.value)
            if (e.value instanceof Array) {
                var s = e.value[Math.floor(Math.random() * i.particles.color.value.length)];
                this.color.rgb = hexToRgb(s)
            } else
                void 0 != e.value.r && void 0 != e.value.g && void 0 != e.value.b && (this.color.rgb = {
                    r: e.value.r,
                    g: e.value.g,
                    b: e.value.b
                }),
                void 0 != e.value.h && void 0 != e.value.s && void 0 != e.value.l && (this.color.hsl = {
                    h: e.value.h,
                    s: e.value.s,
                    l: e.value.l
                });
        else
            "random" == e.value ? this.color.rgb = {
                r: Math.floor(256 * Math.random()) + 0,
                g: Math.floor(256 * Math.random()) + 0,
                b: Math.floor(256 * Math.random()) + 0
            } : "string" == typeof e.value && (this.color = e,
            this.color.rgb = hexToRgb(this.color.value));
        this.opacity = (i.particles.opacity.random ? Math.random() : 1) * i.particles.opacity.value,
        i.particles.opacity.anim.enable && (this.opacity_status = !1,
        this.vo = i.particles.opacity.anim.speed / 100,
        i.particles.opacity.anim.sync || (this.vo = this.vo * Math.random()));
        var n = {};
        switch (i.particles.move.direction) {
        case "top":
            n = {
                x: 0,
                y: -1
            };
            break;
        case "top-right":
            n = {
                x: .5,
                y: -.5
            };
            break;
        case "right":
            n = {
                x: 1,
                y: -0
            };
            break;
        case "bottom-right":
            n = {
                x: .5,
                y: .5
            };
            break;
        case "bottom":
            n = {
                x: 0,
                y: 1
            };
            break;
        case "bottom-left":
            n = {
                x: -.5,
                y: 1
            };
            break;
        case "left":
            n = {
                x: -1,
                y: 0
            };
            break;
        case "top-left":
            n = {
                x: -.5,
                y: -.5
            };
            break;
        default:
            n = {
                x: 0,
                y: 0
            }
        }
        i.particles.move.straight ? (this.vx = n.x,
        this.vy = n.y,
        i.particles.move.random && (this.vx = this.vx * Math.random(),
        this.vy = this.vy * Math.random())) : (this.vx = n.x + Math.random() - .5,
        this.vy = n.y + Math.random() - .5),
        this.vx_i = this.vx,
        this.vy_i = this.vy;
        var r = i.particles.shape.type;
        if ("object" == typeof r) {
            if (r instanceof Array) {
                var c = r[Math.floor(Math.random() * r.length)];
                this.shape = c
            }
        } else
            this.shape = r;
    }
    ,
    i.fn.particle.prototype.draw = function() {
        function e() {
            i.canvas.ctx.drawImage(r, a.x - t, a.y - t, 2 * t, 2 * t / a.img.ratio);
        }
        var a = this;
        if (void 0 != a.radius_bubble)
            var t = a.radius_bubble;
        else
            var t = a.radius;
        if (void 0 != a.opacity_bubble)
            var s = a.opacity_bubble;
        else
            var s = a.opacity;
        if (a.color.rgb)
            var n = "rgba(" + a.color.rgb.r + "," + a.color.rgb.g + "," + a.color.rgb.b + "," + s + ")";
        else
            var n = "hsla(" + a.color.hsl.h + "," + a.color.hsl.s + "%," + a.color.hsl.l + "%," + s + ")";
        switch (i.canvas.ctx.fillStyle = n,
        i.canvas.ctx.beginPath(),
        a.shape) {
        case "circle":
            i.canvas.ctx.arc(a.x, a.y, t, 0, 2 * Math.PI, !1);
            break;
        case "edge":
            i.canvas.ctx.rect(a.x - t, a.y - t, 2 * t, 2 * t);
            break;
        case "triangle":
            i.fn.vendors.drawShape(i.canvas.ctx, a.x - t, a.y + t / 1.66, 2 * t, 3, 2);
            break;
        case "polygon":
            i.fn.vendors.drawShape(i.canvas.ctx, a.x - t / (i.particles.shape.polygon.nb_sides / 3.5), a.y - t / .76, 2.66 * t / (i.particles.shape.polygon.nb_sides / 3), i.particles.shape.polygon.nb_sides, 1);
            break;
        case "star":
            i.fn.vendors.drawShape(i.canvas.ctx, a.x - 2 * t / (i.particles.shape.polygon.nb_sides / 4), a.y - t / 1.52, 2 * t * 2.66 / (i.particles.shape.polygon.nb_sides / 3), i.particles.shape.polygon.nb_sides, 2);
            break;
        case "image":
            if ("svg" == i.tmp.img_type)
                var r = a.img.obj;
            else
                var r = i.tmp.img_obj;
            r && e()
        }
        i.canvas.ctx.closePath(),
        i.particles.shape.stroke.width > 0 && (i.canvas.ctx.strokeStyle = i.particles.shape.stroke.color,
        i.canvas.ctx.lineWidth = i.particles.shape.stroke.width,
        i.canvas.ctx.stroke()),
        i.canvas.ctx.fill()
    }
    ,
    i.fn.particlesCreate = function() {
        for (var e = 0; e < i.particles.number.value; e++)
            i.particles.array.push(new i.fn.particle(i.particles.color,i.particles.opacity.value))
    }
    ,
    i.fn.particlesUpdate = function() {
        for (var e = 0; e < i.particles.array.length; e++) {
            var a = i.particles.array[e];
            if (i.particles.move.enable) {
                var t = i.particles.move.speed / 2;
                a.x += a.vx * t,
                a.y += a.vy * t
            }
            if (i.particles.opacity.anim.enable && (1 == a.opacity_status ? (a.opacity >= i.particles.opacity.value && (a.opacity_status = !1),
            a.opacity += a.vo) : (a.opacity <= i.particles.opacity.anim.opacity_min && (a.opacity_status = !0),
            a.opacity -= a.vo),
            a.opacity < 0 && (a.opacity = 0)),
            i.particles.size.anim.enable && (1 == a.size_status ? (a.radius >= i.particles.size.value && (a.size_status = !1),
            a.radius += a.vs) : (a.radius <= i.particles.size.anim.size_min && (a.size_status = !0),
            a.radius -= a.vs),
            a.radius < 0 && (a.radius = 0)),
            "bounce" == i.particles.move.out_mode)
                var s = {
                    x_left: a.radius,
                    x_right: i.canvas.w,
                    y_top: a.radius,
                    y_bottom: i.canvas.h
                };
            else
                var s = {
                    x_left: -a.radius,
                    x_right: i.canvas.w + a.radius,
                    y_top: -a.radius,
                    y_bottom: i.canvas.h + a.radius
                };
            switch (a.x - a.radius > i.canvas.w ? (a.x = s.x_left,
            a.y = Math.random() * i.canvas.h) : a.x + a.radius < 0 && (a.x = s.x_right,
            a.y = Math.random() * i.canvas.h),
            a.y - a.radius > i.canvas.h ? (a.y = s.y_top,
            a.x = Math.random() * i.canvas.w) : a.y + a.radius < 0 && (a.y = s.y_bottom,
            a.x = Math.random() * i.canvas.w),
            i.particles.move.out_mode) {
            case "bounce":
                a.x + a.radius > i.canvas.w ? a.vx = -a.vx : a.x - a.radius < 0 && (a.vx = -a.vx),
                a.y + a.radius > i.canvas.h ? a.vy = -a.vy : a.y - a.radius < 0 && (a.vy = -a.vy)
            }
            if (isInArray("grab", i.interactivity.events.onhover.mode) && i.fn.modes.grabParticle(a),
            (isInArray("bubble", i.interactivity.events.onhover.mode) || isInArray("bubble", i.interactivity.events.onclick.mode)) && i.fn.modes.bubbleParticle(a),
            (isInArray("repulse", i.interactivity.events.onhover.mode) || isInArray("repulse", i.interactivity.events.onclick.mode)) && i.fn.modes.repulseParticle(a),
            i.particles.line_linked.enable || i.particles.move.attract.enable)
                for (var n = e + 1; n < i.particles.array.length; n++) {
                    var r = i.particles.array[n];
                    i.particles.line_linked.enable && i.fn.interact.linkParticles(a, r),
                    i.particles.move.attract.enable && i.fn.interact.attractParticles(a, r),
                    i.particles.move.bounce && i.fn.interact.bounceParticles(a, r)
                }
        }
    }
    ,
    i.fn.particlesDraw = function() {
        i.canvas.ctx.clearRect(0, 0, i.canvas.w, i.canvas.h),
        i.fn.particlesUpdate();
        for (var e = 0; e < i.particles.array.length; e++) {
            a = i.particles.array[e];
			a.draw();
        }
    }
    ,
    i.fn.particlesEmpty = function() {
        i.particles.array = []
    }
    ,
    i.fn.particlesRefresh = function() {
		return false;
    }
    ,
    i.fn.interact.linkParticles = function(e, a) {
        var t = e.x - a.x
          , s = e.y - a.y
          , n = Math.sqrt(t * t + s * s);
        if (n <= i.particles.line_linked.distance) {
            var r = i.particles.line_linked.opacity - n / (1 / i.particles.line_linked.opacity) / i.particles.line_linked.distance;
            if (r > 0) {
                var c = i.particles.line_linked.color_rgb_line;
                i.canvas.ctx.strokeStyle = "rgba(" + c.r + "," + c.g + "," + c.b + "," + r + ")",
                i.canvas.ctx.lineWidth = i.particles.line_linked.width,
                i.canvas.ctx.beginPath(),
                i.canvas.ctx.moveTo(e.x, e.y),
                i.canvas.ctx.lineTo(a.x, a.y),
                i.canvas.ctx.stroke(),
                i.canvas.ctx.closePath()
            }
        }
    }
    ,
    i.fn.interact.attractParticles = function(e, a) {
        var t = e.x - a.x
          , s = e.y - a.y
          , n = Math.sqrt(t * t + s * s);
        if (n <= i.particles.line_linked.distance) {
            var r = t / (1e3 * i.particles.move.attract.rotateX)
              , c = s / (1e3 * i.particles.move.attract.rotateY);
            e.vx -= r,
            e.vy -= c,
            a.vx += r,
            a.vy += c
        }
    }
    ,
    i.fn.interact.bounceParticles = function(e, a) {
        var t = e.x - a.x
          , i = e.y - a.y
          , s = Math.sqrt(t * t + i * i)
          , n = e.radius + a.radius;
        n >= s && (e.vx = -e.vx,
        e.vy = -e.vy,
        a.vx = -a.vx,
        a.vy = -a.vy)
    }
    ,
    i.fn.modes.pushParticles = function(e, a) {
        i.tmp.pushing = !0;
        for (var t = 0; e > t; t++)
            i.particles.array.push(new i.fn.particle(i.particles.color,i.particles.opacity.value,{
                x: a ? a.pos_x : Math.random() * i.canvas.w,
                y: a ? a.pos_y : Math.random() * i.canvas.h
            })),
            t == e - 1 && (i.particles.move.enable || i.fn.particlesDraw(),
            i.tmp.pushing = !1)
    }
    ,
    i.fn.modes.removeParticles = function(e) {
        i.particles.array.splice(0, e),
        i.particles.move.enable || i.fn.particlesDraw()
    }
    ,
    i.fn.modes.bubbleParticle = function(e) {
		return false;
    }
    ,
    i.fn.modes.repulseParticle = function(e) {
		return false;
    }
    ,
    i.fn.modes.grabParticle = function(e) {
		return false;
    }
    ,
    i.fn.vendors.eventsListeners = function() {
		return false;
    }
    ,
    i.fn.vendors.densityAutoParticles = function() {
        if (i.particles.number.density.enable) {
            var e = i.canvas.el.width * i.canvas.el.height / 1e3;
            i.tmp.retina && (e /= 2 * i.canvas.pxratio);
            var a = e * i.particles.number.value / i.particles.number.density.value_area
              , t = i.particles.array.length - a;
            0 > t ? i.fn.modes.pushParticles(Math.abs(t)) : i.fn.modes.removeParticles(t)
        }
    }
    ,
    i.fn.vendors.checkOverlap = function(e, a) {
        for (var t = 0; t < i.particles.array.length; t++) {
            var s = i.particles.array[t]
              , n = e.x - s.x
              , r = e.y - s.y
              , c = Math.sqrt(n * n + r * r);
            c <= e.radius + s.radius && (e.x = a ? a.x : Math.random() * i.canvas.w,
            e.y = a ? a.y : Math.random() * i.canvas.h,
            i.fn.vendors.checkOverlap(e))
        }
    }
    ,
    i.fn.vendors.createSvgImg = function(e) {
		return false;
    }
    ,
    i.fn.vendors.destroypJS = function() {
        cancelAnimationFrame(i.fn.drawAnimFrame),
        t.remove(),
        pJSDom = null
    }
    ,
    i.fn.vendors.drawShape = function(e, a, t, i, s, n) {
        var r = s * n
          , c = s / n
          , o = 180 * (c - 2) / c
          , l = Math.PI - Math.PI * o / 180;
        e.save(),
        e.beginPath(),
        e.translate(a, t),
        e.moveTo(0, 0);
        for (var v = 0; r > v; v++)
            e.lineTo(i, 0),
            e.translate(i, 0),
            e.rotate(l);
        e.fill(),
        e.restore()
    }
    ,
    i.fn.vendors.exportImg = function() {
        return false; 
    }
    ,
    i.fn.vendors.loadImg = function(e) {
		return false;
    }
    ,
    i.fn.vendors.draw = function() {
        i.fn.particlesDraw()
    }
    ,
    i.fn.vendors.checkBeforeDraw = function() {
        (i.fn.vendors.init(), i.fn.vendors.draw())
    }
    ,
    i.fn.vendors.init = function() {
        i.fn.canvasInit(),
        i.fn.canvasSize(),
        i.fn.canvasPaint(),
        i.fn.particlesCreate(),
        i.fn.vendors.densityAutoParticles(),
        i.particles.line_linked.color_rgb_line = hexToRgb(i.particles.line_linked.color)
    }
    ,
    i.fn.vendors.start = function() {
        isInArray("image", i.particles.shape.type) ? (i.tmp.img_type = i.particles.shape.image.src.substr(i.particles.shape.image.src.length - 3),
        i.fn.vendors.loadImg(i.tmp.img_type)) : i.fn.vendors.checkBeforeDraw()
    }
    ,
    i.fn.vendors.eventsListeners(),
    i.fn.vendors.start()
};
Object.deepExtend = function(e, a) {
    for (var t in a)
        a[t] && a[t].constructor && a[t].constructor === Object ? (e[t] = e[t] || {},
        arguments.callee(e[t], a[t])) : e[t] = a[t];
    return e
}
,
window.requestAnimFrame = function() {
		return window.requestAnimationFrame
}(),
window.cancelRequestAnimFrame = function() {
    return window.cancelAnimationFrame
}(),
window.pJSDom = [],
window.particlesJS = function(e, a) {
    "string" != typeof e && (a = e,
    e = "particles-js"),
    e || (e = "particles-js");
    var t = document.getElementById(e)
      , i = "particles-js-canvas-el"
      , s = t.getElementsByClassName(i);
    if (s.length)
        for (; s.length > 0; )
            t.removeChild(s[0]);
    var n = document.createElement("canvas");
    n.className = i,
    n.style.width = "100%",
    n.style.height = "100%";
    var r = document.getElementById(e).appendChild(n);
    null != r && pJSDom.push(new pJS(e,a))
}
,
window.particlesJS.load = function(e, a, t) {
    var i = new XMLHttpRequest;
    i.open("GET", a),
    i.onreadystatechange = function(a) {
        if (4 == i.readyState)
            if (200 == i.status) {
                var s = JSON.parse(a.currentTarget.response);
                window.particlesJS(e, s),
                t && t()
            } else
                console.log("Error pJS - XMLHttpRequest status: " + i.status),
                console.log("Error pJS - File config not found")
    }
    ,
    i.send()
}
;
