#!/usr/bin/python3
import socket
import time
import os

UDP_PORT = 18999
BUFFER_SIZE = 65530
POLLING_DELAY = 5

def main():
    os.chdir("monitor")
	
    sock = socket.socket(socket.AF_INET,socket.SOCK_DGRAM)
    sock.setsockopt(socket.SOL_SOCKET, socket.SO_BROADCAST,1)
    sock.bind(('', UDP_PORT))
    
    run = True
    while run:
        f = open("latest-sensor-data.buffer", "r")
        sensor_data = f.read()
        f.close()
      
        f = open("/var/log/syslog", "r")
        hashlog = []
        line = "\n" ##file.readline() retorna "" no fim do ficheiro e \n em linhas so com o newline
        while not(line == ""):
            try:
                line = f.readline()
                if line.count("xmrig") > 0 and line.count("speed") > 0:
                    hashlog.append(line)
            except:
                pass
		
        try:
            hashrate = hashlog[max(len(hashlog)-1,0)].split(" ")[13]
        except:
            pass
        print(hashrate)

        pkt = socket.gethostname() + chr(30) + hashrate + chr(30) + "sensors"
        try:
            sock.sendto(str.encode(pkt), ('192.168.1.32', UDP_PORT))
        except OSError:
            print("Waiting for network.")
		
        time.sleep(POLLING_DELAY)
main()
