#!/usr/bin/python3
import tkinter as tk
from tkinter import * 
from tkinter import ttk
import socket
import threading
import time
import datetime

fdatetime = lambda: datetime.datetime.now().strftime("%H:%M:%S %b/%d/%G")

UDP_PORT = 18999
BUFFER_SIZE = 65530
FIRST_IP = 20
        
def listen(master, tree):
    workers = []
    hashrates = {}
    
    sock = socket.socket(socket.AF_INET,socket.SOCK_DGRAM)
    sock.setsockopt(socket.SOL_SOCKET, socket.SO_BROADCAST,1)
    sock.bind(('', UDP_PORT))
    
    while True:
        pkt, (addr, port) = sock.recvfrom(BUFFER_SIZE)
        bytes.decode(pkt)
        data = pkt.split(str.encode("\x1e")) ## o que sai daqui [b'hostname',b'hashrate',b'sensors']
        
        worker_hn = bytes.decode(data[0])
        
        if worker_hn in workers:
            iid = workers.index(worker_hn)
            hashrates[worker_hn] = float(bytes.decode(data[1]))
            idx = int(addr.split(".")[3])-FIRST_IP+1
            if not tree.index(iid)-1 == idx:
                ##tree.move(iid, "", idx)
                pass
            tree.item(iid, values=(bytes.decode(data[0]), addr, bytes.decode(data[1]) + " h/s", fdatetime()))
            #print(bytes.decode(data[0]), "---", idx, tree.index(iid))
        else:
            workers.append(worker_hn)
            try:
                hashrates[worker_hn] = float(bytes.decode(data[1]))
            except ValueError:
                pass
            iid = len(workers)-1
            tree.insert(parent="", index=int(addr.split(".")[3]), iid=iid, values=(bytes.decode(data[0]), addr, bytes.decode(data[1]) + " h/s", fdatetime()))	
            tree.pack(side=tk.TOP,fill=tk.X)
        
        t_hashrate = 0.0
        for worker in hashrates.values():
            try:
                t_hashrate += worker
            except ValueError:
                pass
        tree.item(999, values=("total", "N/A", str(round(t_hashrate,1)) + " h/s", fdatetime()))
        ##print(hashrates)
            

def main(): 
    
    master = tk.Tk()
    master.title("Workers Info Monitor")
    master.resizable(False, False)
                
    tree = ttk.Treeview(master)
    
    recive_thread = threading.Thread(target = listen, args=(master, tree)) 
    recive_thread.start()
    
    tree["columns"]=("hn","ip","hr","ts")
    tree.column('#0', width=0, stretch=NO)
    tree.column("hn", width=127, minwidth=127, stretch=tk.NO)
    tree.column("ip", width=127, minwidth=127, stretch=tk.NO)
    tree.column("hr", width=127, minwidth=127, stretch=tk.NO)
    tree.column("ts", width=255, minwidth=255, stretch=tk.NO)
        
    tree.heading('#0', text='', anchor=CENTER)
    tree.heading("hn", text="Hostname",anchor=tk.W)
    tree.heading("ip", text="IP",anchor=tk.W)
    tree.heading("hr", text="Hash-Rate",anchor=tk.W)
    tree.heading("ts", text="Updated",anchor=tk.W)
                
    tree.insert(parent="", index=0, iid=999, values=("total", "N/A", "N/A h/s", fdatetime()))	

    tree.pack(side=tk.TOP,fill=tk.X)
    
    master.mainloop()
    
if __name__ == '__main__':
    main()
