#define LED_R 4
#define LED_G 3
#define SENSOR_L 2
#define SENSOR_E 1
#define BUZZER 5
#define NO_VOL 0
#define MAX_VOL 1023
#define FREQ 440
#define TEMPO_L 5000

void setup() {
  pinMode(LED_R, OUTPUT);
  pinMode(LED_G, OUTPUT);
  pinMode(SENSOR_L, INPUT);
  pinMode(SENSOR_E, INPUT);
  pinMode(BUZZER, OUTPUT);
  
}

void loop() {
  if(!(digitalRead(SENSOR_L)) && digitalRead(SENSOR_E)){
    digitalWrite(LED_G, HIGH);
    tone(BUZZER, FREQ, MAX_VOL);
    delay(TEMPO_L);
    digitalWrite(LED_G, LOW);
    tone(BUZZER, FREQ, NO_VOL); //isto é equivalente ao noTone(), suponho
  }else{
    digitalWrite(LED_R, HIGH);  
    delay(1000);
    digitalWrite(LED_R, LOW); 
  }
}

/*
  L E
  0 0 !(digitalRead(SENSOR_L)) && !(digitalRead(SENSOR_E))
  0 1 !(digitalRead(SENSOR_L)) && digitalRead(SENSOR_E)
  1 0 digitalRead(SENSOR_L) && !(digitalRead(SENSOR_E))
  1 1 digitalRead(SENSOR_L) && digitalRead(SENSOR_E)
*/
