# Inspired from http://coding4streetcred.com/blog/post/Asymmetric-Encryption-Revisited-(in-PyCrypto)
# PyCrypto docs available at https://www.dlitz.net/software/pycrypto/api/2.6/
# abananacaxi https://gist.github.com/syedrakib/241b68f5aeaefd7ef8e2

from Crypto import Random as random 
from Crypto.PublicKey import RSA as rsa
import base64
import secrets


#numeros aleatorios seguros
strong_rand_str = lambda s: ''.join([secrets.choice("abcdefghijklpnopkrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ") for i in range(0,s)]) 

def generate_keys():
    # RSA modulus length must be a multiple of 256 and >= 1024
    modulus_length = 256*16 # use larger value in production tipo 4096
    privatekey = rsa.generate(modulus_length, random.new().read)
    publickey = privatekey.publickey()
    return base64.b64encode(privatekey.exportKey()).decode(), base64.b64encode(publickey.exportKey()).decode()

def encrypt_message(a_message , public_key_64): ##message tem de ser < que 684 chars
    if len(a_message) >= 684:
        a_message = a_message[0:683]
    public_key = rsa.importKey(base64.b64decode(public_key_64))
    encrypted_msg = base64.b64encode(public_key.encrypt(a_message.encode(), 32)[0]).decode()
    return encrypted_msg

def decrypt_message(encoded_encrypted_msg, private_key_64):
    private_key = rsa.importKey(base64.b64decode(private_key_64))
    decoded_decrypted_msg = private_key.decrypt(base64.b64decode(encoded_encrypted_msg)).decode()
    return decoded_decrypted_msg
    
def create_challenge(client_pub_key):
    solution = strong_rand_str(512)
    return encrypt_message(solution, client_pub_key), solution ##challenge
