#!/usr/bin/python3
import sys
import json
import random
import socket
import os
import time
import secrets
import threading

from Crypto import Random as random 
from Crypto.PublicKey import RSA as rsa
import base64
import secrets

global kill, chan
kill = False
chan = "#Geral"
tag = "teste123"
strong_rand_str = lambda s: ''.join([secrets.choice("abcdefghijklpnopkrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ") for i in range(0,s)]) 

def generate_keys():
    # RSA modulus length must be a multiple of 256 and >= 1024
    modulus_length = 256*16 # use larger value in production tipo 4096
    privatekey = rsa.generate(modulus_length, random.new().read)
    publickey = privatekey.publickey()
    return base64.b64encode(privatekey.exportKey()).decode(), base64.b64encode(publickey.exportKey()).decode()

def encrypt_message(a_message , public_key_64): ##message tem de ser < que 684 chars
    if len(a_message) >= 684:
        a_message = a_message[0:683]
    public_key = rsa.importKey(base64.b64decode(public_key_64))
    encrypted_msg = base64.b64encode(public_key.encrypt(a_message.encode(), 32)[0]).decode()
    return encrypted_msg

def decrypt_message(encoded_encrypted_msg, private_key_64):
    private_key = rsa.importKey(base64.b64decode(private_key_64))
    decoded_decrypted_msg = private_key.decrypt(base64.b64decode(encoded_encrypted_msg)).decode()
    return decoded_decrypted_msg
    
def create_challenge(client_pub_key):
    solution = strong_rand_str(512)
    return encrypt_message(solution, client_pub_key), solution ##challenge

def listen(sc):
    global kill
    while True:
        try:
            msg = sc.recv(4096).decode()
        except OSError:
            return
        msg = json.loads(msg)
        
        if msg['op'] == 0:
            p = {
                "op": 0,
                "server_time": int(time.time())
            }
            msg =json.dumps(p)
            sc.send(msg.encode())
        elif msg['op'] == 3:
            print('\u001b[16D', end='')
            print('\u001b[K', end='')
            print("#",msg['message'], "\n", end='')
            print("", end='')
        else:
            print(msg)

#aa
def main():
    host   = socket.gethostbyname('liug.eu')
    client(host)
    
def client(host):
    #o objeto socket é :: s
    global sc, kill
    sc = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
    sc.settimeout(24)
    #conectar ao servidor
    sc.connect((host, 7450))
    print("Conectado ao destino.\n")
    
    private_key, public_key = generate_keys()
    
    p = {
        "op": 1,
        "tag": tag,
        "public_key": public_key,
        "client_time": int(time.time())			 
    }
    
    msg = json.dumps(p)
    sc.send(str.encode(msg))
    msg = sc.recv(4096).decode()
    msg = json.loads(msg)
    solution = decrypt_message(msg['challenge'], private_key)
    p = {
        "op": 1,
        "solution": solution,
    }
    msg = json.dumps(p)
    sc.send(str.encode(msg))
    print(sc.recv(4096).decode())
    
    listen_thread = threading.Thread(target = listen, args=(sc,)) 
    listen_thread.start()

    while True:
        m = "teste de envio de mensagem internó"
        time.sleep(5)
        p = {
            "op": 2,
            "message": m,
            "chan": chan,
            "is_dm": True,
            "is_text": True,
            "recipient_tripcode": "teste123#501bc8eac8f3fa", ##placeholder !!!!!!!!!!!AQUI!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
            "client_time": int(time.time())
        }
        
        msg = json.dumps(p).encode()
        sc.send(msg)

# para apanhar o keyboardinterupt
try:
    main()
except KeyboardInterrupt:
    kill = True
    print('Interrupted')
    #fecha os sockets
    sc.shutdown(socket.SHUT_RDWR)
    sc.close()
    exit(0)
