#!/usr/bin/python3

import discord
import mysql.connector
import time
import re
import sys
import socket
import threading
import base64
import binascii
import json
import signal
import requests

import images ##selenium driver is autostarted make sure it is killed before exiting by calling images.kill()
import config
import logger
import webapi

#log stdout to file
sys.stdout = open(config.bot_log_path, 'w')

print(time.time())

##sock to recive liug pushes
#init liug socket
sock = socket.socket(socket.AF_INET, socket.SOCK_STREAM)

client = discord.Client()

run = True

def shutdown(_signo, _stack_frame):
    run = False
    print("init_d:shutdown")
    images.kill()
    try:
        sock.shutdown(socket.SHUT_RDWR)
    except:
        pass
    
    sock.close()
    client.logout()
    client.close()
    sys.exit(0)
    return

def listen():
    (cl_sock_o, ip) = sock.accept()

    read = True
    decoded_msg = ""
    msg_buffer = ""
    while read:
        msg_buffer = cl_sock_o.recv(1024).decode()
        decoded_msg +=msg_buffer
        if "\n" in msg_buffer:
            read = False

    cl_sock_o.shutdown(socket.SHUT_RDWR)

    if not decoded_msg[0] == " ":
        print("listen_d:message does not have encoding indication")
        listen()

    decoded_msg[:-1] ##remove last char \n
    decoded_msg[1:] ##remove first " " char indicator
    decoded_msg.split(" ")
    
    print(decoded_msg)
    
    try:
        push_msg = base64.b64decode(decoded_msg)
    except binascii.Error:
        print("listen_d:payload is not base64 encoded")
        listen()

    try:
        push_msg = push_msg.decode()
    except UnicodeDecodeError:
        print("listen_d:payload badly encoded")
        listen()
    
    print("listen_d:done "+push_msg)
    push(push_msg)
    listen()

def push(push_msg):
    print("push_d:pushing")
    (liug_chan, msg_buffer) = push_msg.split("<",1)
    (author, message) = msg_buffer.split(">",1)
    
    if not liug_chan[0] == "d":
        print("push_d:recived liug channel is not a discord channel")
        return

    try:
        (NULL, discord_server, discord_chan) = liug_chan.split("_",3)
    except ValueError:
        print("push_d:recived discord channel is malformed")
        return
    discord_server = discord_server.replace("-"," ")

    fake_server = True
    for server_i in list(client.servers):
        if discord_server == str(server_i):
            print("push_d:server found "+str(server_i))
            fake_server = False
            discord_server = server_i

    if fake_server:
        print("push_d:server not found")
        return
    else:
        fake_chan = True
        for chan_i in  discord_server.channels:
            if discord_chan == str(chan_i) and str(chan_i.type) == 'text':
                print("push_d:channel found "+str(chan_i) + " " + str(chan_i.type))
                fake_chan = False
                discord_chan = chan_i
        if fake_chan:
            print("push_d:channel not found")
            return
        else:
            print("push_d:sending message")
            discord_msg = "__**"+author+"**__ **said:**\n"+message
            
            response = webapi.push(discord_chan.id, message)
            print("push_d:post result "+ response.text)
    sys.stdout.flush()
    return



@client.event
async def on_message(message):
    # we do not want the bot to reply to itself
    if message.author == client.user:
        return
    if message.author.bot: ##dont reply to bots
        return
        
    if message.content.lower().startswith("iughelp"):
        webapi.push(message.channel.id, "Hello! Where do you want to shitpost today?")
        return

    if message.content.lower().startswith("shitify "):
        search = message.content[8:]
        search = re.sub('[\"\']', '', search)
        print("shit_d:querry:"+search)
        loading_message = webapi.push(message.channel.id,"Searching for "+ search)
        webapi.typing(message.channel.id)
        ##context str conains error text or the filename on sucess
        successful , context_str = images.update_shit_image(search)
        if successful:
            await client.send_file(message.channel,context_str)
        else:
            await client.send_file(message.channel,"error.jpeg")
            webapi.push(message.channel.id,context_str)
        webapi.delete(message.channel.id,loading_message['id'])
    
    if message.content.lower().startswith("img "):
        search = message.content[4:]
        search = re.sub('[\"\']', '', search)
        print("gimg_d:querry:"+search)
        loading_message = webapi.push(message.channel.id,"Searching for "+ search)
        webapi.typing(message.channel.id)
        ##context str conains error text or the filename on sucess
        successful, context_str = images.update_good_image(search)
        if successful:
            await client.send_file(message.channel,context_str)
        else:
            await client.send_file(message.channel,"error.jpeg")
            webapi.push(message.channel.id,context_str)
        webapi.delete(message.channel.id,loading_message['id'])

    if message.server == None:
        return

    try:
        conn = mysql.connector.connect(**config.mysql)
    except mysql.connector.Error as err:
        print(err)
        return
    
    print("lisn_d:newmsgfrm:"+str(message.author))
    usr = message.author.name.replace("<","«").replace(">","»")
    
    msg = message.content.replace("<","«").replace(">","»")
    msg = re.sub(r'((http|https)\:\/\/[a-zA-Z0-9\-\.]+\.[a-zA-Z]{2,3}(\/\S*)?)', r'<a class="prslink" href="\1">\1</a>', msg) 

    chan = "d_" + message.server.name + "_" + message.channel.name
    chan = chan.replace("<","«").replace(">","»")
    chan = chan.replace(" ","-")

    vals = {
        "usr" : usr,
        "message" : msg,
        "chan" : chan
    }
    sql = "INSERT INTO userStringTable (Input, InputNumber, TimeENTER, name, isver, chan) VALUES (%(message)s, DEFAULT(InputNumber), NOW(), %(usr)s, 1, %(chan)s);"
    cursor = conn.cursor()
    cursor.execute(sql, vals)
    conn.commit()
    cursor.close()
    conn.close()
    sys.stdout.flush()

@client.event
async def on_ready():
    await client.change_presence(status=discord.Status.online, game=discord.Game(name="you masturbate.", type=3))
    print("init_d:logged in as "+client.user.name+" - "+client.user.id)
    print('init_d:ready')
    
    ##sock to recive liug pushes
    #init liug socket
    sock.setsockopt(socket.SOL_SOCKET, socket.SO_REUSEADDR, 1)
    ##check if socket is released will trigger if process is duplicated
    address_in_use = False
    try:
        sock.bind((config.B_ADDR, config.B_PORT))
    except: ##OSError 98 address already in use
        address_in_use = True
        print("init_d:error could not bind push_d tcp socket")
    
    if not address_in_use:
        sock.listen(5)
        listen_thread.start()
    else:
        shutdown(15,None)

    print("init_d:done")
    sys.stdout.flush()

##thread to push to liug
listen_thread = threading.Thread(target = listen)

#Register SIGTERM to deisconect from dicksword servers properly and to kill geckodriver
signal.signal(signal.SIGTERM,shutdown)

##this funtion blocks
client.run(config.TOKEN)
